mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/REISEN52")


declare_loadout({
	CLSID        = "REISEN52_TANK",
	category     = CAT_FUEL_TANKS,
	Picture	     = "PTB.png",
	Weight_Empty = 20,
	Weight       = 20 + 300 * 0.8,
	attribute    = {1, 3, 43, WSTYPE_PLACEHOLDER},
	shape_table_data 	= 
	{
		{
			file  	 = 'REISEN52-TANK';
			life  	 = 60;
	        fire  = { 0, 1};
			username = "REISEN52 Fuel tank";
			index    =  WSTYPE_PLACEHOLDER;
		},
	},
	Elements     =
	{
		[1]	=
		{
			Position  =	{0, 0, 0},
			ShapeName =	"REISEN52-TANK",
		},
	}, -- end of Elements
	displayName	= _("REISEN52 Fuel tank"),
	Cx_pil      = 0.002197266,
})

declare_weapon({category = CAT_SHELLS,name =   "G97_APT",
	user_name		= _("7.7mm"),
	model_name		= "tracer_bullet_yellow",
	v0				= 745.0,
	Dv0				= 0.0082,
	Da0				= 0.0004,
	Da1				= 0.0,
	mass			= 0.0096,
	explosive		= 0.003,
	life_time		= 7,
	caliber			= 7.7,
	s				= 0.0,
	j				= 0.0,
	l				= 0.0,
	charTime		= 0,
	cx				= {1.0,0.62,0.65,0.175,1.8},
	k1				= 2.9e-08,
	tracer_off		= 3,
	scale_tracer	= 1,
	cartridge		= 0,
})

declare_weapon({category = CAT_SHELLS,name =   "G97_API",
	user_name		= _("7.7mm"),
	model_name		= "tracer_bullet_red",
	v0				= 745.0,
	Dv0				= 0.0082,
	Da0				= 0.0004,
	Da1				= 0.0,
	mass			= 0.0096,
	explosive		= 0.003,
	life_time		= 7,
	caliber			= 7.7,
	s				= 0.0,
	j				= 0.0,
	l				= 0.0,
	charTime		= 0,
	cx				= {1.0,0.62,0.65,0.175,1.8},
	k1				= 2.9e-08,
	tracer_off		= 3,
	scale_tracer	= 1,
	cartridge		= 0,
})

declare_weapon({category = CAT_SHELLS,name =   "G99_APT",
	user_name		= _("20mm"),
	model_name		= "tracer_bullet_yellow",
	v0				= 750.0,
	Dv0				= 0.0080,
	Da0				= 0.0004,
	Da1				= 0.0,
	mass			= 0.125,
	round_mass		= 0.211,
	explosive		= 0.009,
	life_time		= 7,
	caliber			= 20,
	s				= 0.0,
	j				= 0.0,
	l				= 0.0,
	charTime		= 0,
	cx				= {0, 0.77, 0.8, 0.23, 2.3},
	k1				= 2e-08,
	tracer_off		=-1,
	tracer_on		= 0,
	scale_tracer	= 1,
	smoke_tail_life_time = 0.7,
	cartridge		= 0,
})

declare_weapon({category = CAT_SHELLS,name =   "G99_API",
	user_name		= _("20mm"),
	model_name		= "tracer_bullet_red",
	v0				= 750.0,
	Dv0				= 0.0080,
	Da0				= 0.0004,
	Da1				= 0.0,
	mass			= 0.125,
	round_mass		= 0.211,
	explosive		= 0.009,
	life_time		= 7,
	caliber			= 20,
	s				= 0.0,
	j				= 0.0,
	l				= 0.0,
	charTime		= 0,
	cx				= {0, 0.77, 0.8, 0.23, 2.3},
	k1				= 2e-08,
	tracer_off		= 4,
	tracer_on		= 0.01,
	scale_tracer	= 1,
	smoke_tail_life_time = 0.7,
	cartridge		= 0,
})

function G97(tbl)
	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "97"
	tbl.supply 	 = 
	{
		shells = {"G97_APT","G97_API"},
		mixes  = {{1,2,1,2}},
		count  = 450,
	}
	tbl.gun = 
	{
		max_burst_length = 500,
		rates 			 = {800},-- unsync mount
		recoil_coeff 	 = 1.0,
		barrels_count 	 = 1,
	}
	tbl.effect_arg_number	= tbl.effect_arg_number
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1200
	tbl.drop_cartridge 			= 204
	tbl.azimuth_initial 		=  tbl.azimuth_initial
	tbl.elevation_initial 		=  tbl.elevation_initial
	tbl.supply_position  	= tbl.supply_position
	tbl.muzzle_pos			= {0,0,0} -- all position from connector
	tbl.ejector_pos 		= tbl.ejector_pos
	tbl.ejector_dir 		= {0.0, -5.0,  0.0}
	
	return declare_weapon(tbl)
end

function G99_2(tbl)
	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "99-2"
	tbl.supply 	 = 
	{
		shells = {"G99_APT","G99_API"},
		mixes  = {{1,2,1,2}},
		count  = 125,
	}
	tbl.gun = 
	{
		max_burst_length = 500,
		rates 			 = {800},-- unsync mount
		recoil_coeff 	 = 1.0,
		barrels_count 	 = 1,
	}
	tbl.effect_arg_number	= tbl.effect_arg_number
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1200
	tbl.drop_cartridge 			= 204
	tbl.azimuth_initial 		=  tbl.azimuth_initial
	tbl.elevation_initial 		=  tbl.elevation_initial
	tbl.supply_position  	= tbl.supply_position
	tbl.muzzle_pos			= {0,0,0} -- all position from connector
	tbl.ejector_pos 		= tbl.ejector_pos
	tbl.ejector_dir 		= {0.0, -5.0,  0.0}
	
	return declare_weapon(tbl)
end


REISEN52 =  {
	Name 				=   'REISEN52',
	DisplayName			= _('REISEN 52 kou'),
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	Picture 			= current_mod_path.."/REISEN52.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "REISEN52",
	shape_table_data 	= 
	{
		{
			file  	 = 'REISEN52';
			life  	 = 18; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'p51-oblomoki'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'REISEN52';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "p51-oblomoki";
			file  = "p51-oblomoki";
			fire  = { 240, 2};
		},
	},
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Battleplanes",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
    LandRWCategories = 
    {
        [1] = 
        {
            Name = "AircraftCarrier",
        },
    },
    TakeOffRWCategories = 
    {
        [1] = 
        {
            Name = "AircraftCarrier With Catapult",
        },
    },

	-------------------------
	M_empty 					= 1894, -- kg
	M_nominal 					= 2743.41, -- kg
	M_max 						= 3083.07, -- kg
	M_fuel_max 					= 590 * 0.8, -- kg
	H_max 					 	= 11740, -- m
	average_fuel_consumption 	= 0.302, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 56, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 125,-- Cruise speed (for AI)
	V_take_off 					= 53, -- Take off speed in m/s (for AI)
	V_land 						= 35.5, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 156.94, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 156.94, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 17.75, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.46, -- Max speed in Mach (for AI)
	Ny_min 						= -2, -- Min G (for AI)        edited by baco30, was -4
	Ny_max 						= 5.0,  -- Max G (for AI)        edited by baco30, was +8
	Ny_max_e 					= 5.0,  -- Max G (for AI)        edited by baco30, was +8
	AOA_take_off 				= 0.157, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	main_gear_pos 				= {0.1, -1.83, 1.772}, -- main gear coords
	nose_gear_pos 				= {-6.43, -0.335,	0}, -- nosegear coord
	has_differential_stabilizer = false,
	tand_gear_max 				= 0.577,
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 21.3, -- wing area in m2
	wing_span 					= 11.0, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 5600, -- thrust in kg (44kN)
	thrust_sum_ab 				= 5600, -- thrust inkg (71kN)
	length 						= 9.12, -- full lenght in m
	height 						= 3.509, -- height in m
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1055, -- Max range in km (for AI)
	RCS 						= 2.5, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.1, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	wing_tip_pos 				= {-0.744, 0.135, 5.452}, -- wingtip coords for visual effects
	nose_gear_wheel_diameter 	= 0.145, -- in m
	main_gear_wheel_diameter 	= 0.595, -- in m
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	engines_count				= 1,
	engines_nozzles = {
	}, -- end of engines_nozzles
	crew_size	 = 1,
	crew_members = 
	{
		[1] = 
		{
			pilot_name			= 56,
			ejection_seat_name	= 0,
			drop_canopy_name	= "NULL",
			pos					= {-1.132, 0.225, 0},
			canopy_pos			= {0, 0, 0},
		}, -- end of [1]
	}, -- end of crew_members

	fires_pos = 
	{
		[1] = 	{-1.961,	-0.053,	0.349},
		[2] = 	{-0.987,	-0.28,	1.004},
		[3] = 	{-0.987,	-0.28,	-1.004},
		[4] = 	{-0.13,		-0.249,	0.991},
		[5] = 	{-0.13,		-0.249,	-0.991},
		[6] = 	{-0.665,	-0.056,	3.017},
		[7] = 	{-0.665,	-0.056,	-3.017},
		[8] = 	{-5.156,	0.205,	0.357},
		[9] = 	{-5.156,	0.205,	-0.357},
		[10] = 	{-0.017,	0.103,	0.571},
		[11] = 	{-0.017,	0.103,	-0.571},
	}, -- end of fires_pos

	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,

	--sensors
	detection_range_max		 = 0,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = {
		OPTIC = "Merkury LLTV", -- For night goggles imitation
   	},

	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Guns = {
		-- 7.7mm 左
		G97({
				muzzle_pos_connector = "Gun_point_02",
				effect_arg_number = 433,
				azimuth_initial = 0.066,
				elevation_initial = 0.0,
				supply_position = {3.755, 0.775, -0.23},
				ejector_pos = {-1.617, -1.137, -0.23},
	            effects = {
	                {name = "FireEffect", arg = 433},
	            }
				}),
		-- 7.7mm 右
		G97({
				muzzle_pos_connector = "Gun_point_01",
				effect_arg_number = 432,
				azimuth_initial = 0.066,
				elevation_initial = 0.0,
				supply_position = {3.755, 0.775, 0.23},
				ejector_pos = {-1.617, -1.137, -0.23},
	            effects = {
	                {name = "FireEffect", arg = 432},
	            }
				}),
		-- 20mm 左
		G99_2({
				muzzle_pos_connector	= "Gun_point_04",
				effect_arg_number = 435,
				azimuth_initial = 0.563,
				elevation_initial = 0.25,
				supply_position = {1.805, -0.222, -1.965},
				ejector_pos = {-1.387, -0.15, 0},
	            effects = {
	                {name = "FireEffect", arg = 435},
	            }
				}),
		-- 20mm 右
		G99_2({
				muzzle_pos_connector	= "Gun_point_03",
				effect_arg_number = 434,
				azimuth_initial =  0.563,
				elevation_initial = 0.25,
				supply_position = {1.805, -0.222, 1.965},
				ejector_pos = {-1.387, -0.15, 0},
	            effects = {
	                {name = "FireEffect", arg = 434},
	            }
				}),
	},

	Pylons = {
		pylon(1, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_1"}, {}),
		pylon(2, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_2"}, {}),
		pylon(3, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_3"}, {}),
		pylon(4, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_5"},
		{
			{ CLSID = "60KG_BOMB" },
			{ CLSID = "30KG_BOMB" },
		}),
		pylon(5, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_6", FiZ = -1.53},
		{
			{ CLSID = "REISEN52_TANK" },
		}),
		pylon(6, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_7"}, {}),
		pylon(7, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_8"},
		{
			{ CLSID = "60KG_BOMB" },
			{ CLSID = "30KG_BOMB" },
		}),
		pylon(8, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_10"}, {}),
		pylon(9, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_11"}, {}),
		pylon(10, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_12"}, {}),
    },

	Tasks = {
        aircraft_task(CAP),
		aircraft_task(Escort),
        aircraft_task(FighterSweep),
		aircraft_task(GroundAttack),
        aircraft_task(CAS),
        aircraft_task(AFAC),
		aircraft_task(RunwayAttack),
		aircraft_task(AntishipStrike),
		aircraft_task(Intercept),
    },	
	DefaultTask = aircraft_task(CAP),
	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.1,	-- zero AoA lift coefficient
			Mzalfa		=	4.355,	-- coefficients for pitch agility
			Mzalfadt	=	0.8,	-- coefficients for pitch agility
			kjx			=	2.25,	
			kjz			=	0.00125,
			Czbe		=	-0.016,	-- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0277,	-- coefficient, drag, gear
			cx_flap		=	0.095,	-- coefficient, drag, full flaps
			cy_flap		=	0.31,	-- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,	-- coefficient, drag, breaks
			table_data = {
			--       M		Cx0		Cya		    B		B4	    Omxmax	    Aldop	    Cymax
					{0.0,	0.0187,	0.0746,		0.052,	0.012,	0.15,		22.0,		1.45,	},
					{0.2,	0.0187,	0.0746,		0.052,	0.012,	0.796144,	22.0,		1.45,   },
					{0.3,	0.0187,	0.0722,		0.052,	0.015,	1.24,		19.0,		1.2,    },
					{0.5,	0.0187,	0.0798,		0.045,	0.025,	1.323,		17.0,		1.08,   },
					{0.59,	0.0187,	0.084,		0.047,	0.026,	1.129077,	17.0,		1.07,   },
					{0.67,	0.0187,	0.0907,		0.047,	0.021,	0.943,		14.5,		0.98,   },
					{0.74,	0.0227,	0.0855,		0.08,	0.16,	0.675,		10.0,	  	0.72,   },
					{0.76,	0.032,	0.078,		0.1,	0.25,	0.577,		9.0,  		0.6,    },
					{0.8,	0.063,	0.072,		0.2,	0.36,	0.456,		6.0,	    0.4,	},
					{0.83,	0.1,	0.0725,		0.34,	2.4,	0.32,		4.5,		0.3,	},
					{0.9,	0.126,	0.073,		0.56,	3.0,	0.076,		3.0,	    0.2,	},
					{1.1,	0.16,	0.03,		0.56,	3.0,	0.076,		1.0,		0.3		},
			}
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg		=	67.5,	-- RPM at idle
			MinRUD	=	0,		-- Min state of the throttle
			MaxRUD	=	1,		-- Max state of the throttle
			MaksRUD	=	1,		-- Military power state of the throttle
			ForsRUD	=	1,		-- Afterburner state of the throttle
			typeng	=	2,		-- PISTON ENGINE
			--
			--	E_TURBOJET = 0
			--	E_TURBOJET_AB = 1
			--	E_PISTON = 2
			--	E_TURBOPROP = 3
			--	E_TURBOFAN = 4
			--	E_TURBOSHAFT = 5
			--
			hMaxEng	=	12.5,	-- Max altitude for safe engine operation in km
			dcx_eng	=	0.0015,	-- Engine drag coeficient
			cemax	=	0.37,	-- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37,	-- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1800,	-- altitude coefficient for max thrust
			dpdh_f	=	1800,	-- altitude coefficient for AB thrust
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,
			MAX_Manifold_P_2	= 206570,
			MAX_Manifold_P_3	= 226648,
			k_after_cool		= 0.54,
			Displ				= 27,
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 12,
			Nu_0				= 1.2,
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 3.45,
			MOI_prop			= 65,
			k_gearbox			= 2.088,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
			table_data = 
			{
			--   M			Pmax          edited by baco30, reduced ~40%
				{0.0,		11600.0},
				{0.1,		10900.0},
				{0.2,		10000.0},
				{0.3,		 9300.0},
				{0.4,		 8500.0},
				{0.5,		 7900.0},
				{0.6,		 7400.0},
				{0.7,		 7000.0},
				{0.8,		 6800.0},
				{0.9,		 4100.0},
				{1.9,		 2400.0}
			}
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	}, -- end of SFM_Data
	
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
				[1]		= {critical_damage = 5, args = {150}}, -- nose left
				[2]		= {critical_damage = 5, args = {149}}, -- nose right
				[3]		= {critical_damage = 10, args = {65}}, -- cockpit
				[4]		= {critical_damage = 5, args = {154}}, -- cabin left
				[5]		= {critical_damage = 5, args = {153}}, -- cabin right
				[11]	= {critical_damage = 3, args = {147}}, -- engine in left
				[25]	= {critical_damage = 3, args = {226}}, -- eleron left
				[26]	= {critical_damage = 3, args = {216}}, -- eleron right
				[35]	= {critical_damage = 7, args = {225}, deps_cells = {25, 37}}, -- wing left
				[36]	= {critical_damage = 7, args = {215}, deps_cells = {26, 38}}, -- wing right
				[37]	= {critical_damage = 4, args = {227}}, -- flap in left
				[38]	= {critical_damage = 4, args = {217}}, -- flap in right
				[43]	= {critical_damage = 6, args = {243}, deps_cells = {54}}, -- fin bottom left
				[47]	= {critical_damage = 6, args = {236}, deps_cells = {49}}, -- stabilizer in left
				[48]	= {critical_damage = 6, args = {234}, deps_cells = {50}}, -- stabilizer in right
				[49]	= {critical_damage = 3, args = {240}}, -- elevator out left
				[50]	= {critical_damage = 3, args = {238}}, -- elevetor out  right
				[54]	= {critical_damage = 3, args = {247}}, -- rudder right
				[55]	= {critical_damage = 7, args = {81}}, -- tail
				[56]	= {critical_damage = 5, args = {158}}, -- tail left
				[57]	= {critical_damage = 5, args = {157}}, -- tail right
				[59]	= {critical_damage = 5, args = {148}}, -- nose bottom
				[64]	= {critical_damage = 3, args = {429}}, -- blade 1 in
				[67]	= {critical_damage = 3, args = {430}}, -- blade 2 in
				[70]	= {critical_damage = 3, args = {431}}, -- blade 3 in
				[73]	= {critical_damage = 3, args = {119}}, -- blade 4 in
				[82]	= {critical_damage = 5, args = {152}}, -- fuselage bottom
				[83]	= {critical_damage = 2, args = {134}}, -- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}}, -- right wheel
	},

	DamageParts = 
	{  
		[1] = "REISEN52-OBLOMOK-WING-R",
		[2] = "REISEN52-OBLOMOK-WING-L",
	},

	lights_data = 
	{
		typename = "collection",
		lights = 
		{
			[1] = -- ストロボライト
			{
			},
			[2] = -- ランディングライト
			{
			},
		    [3]	= -- ナビゲーションライト
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					color = {0.32, 0.0, 0.07},
					position  = {-0.272, 0.133, -5.341},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					color = {0, 0.26, 0.18},
					position = {-0.272, 0.133, 5.341},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					color = {0.8, 0.8, 0.8},
					position  = {-6.886, 0.0, 0.0},
					argument  = 203
					},
				}
			},
		    [4] = -- フォーメーションライト
			{
			},
			[5]	= -- テールフック作動のためのダミー
			{
		    	typename = "collection",
				lights =
				{
					 -- amber recognotion light 
					{typename = "omnilight",
					connector = "FORM_LIGHTS_2",
					color = {0.0, 0.0, 0.0},
					pos_correction = {0, 0, 0},
					argument  = 202
					},
				}
			}
		}
	},  -- end of lights_data
}

add_aircraft(REISEN52)
